/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AdminMessageUtil {
    private ResourceBundle m_resBundle;
    private String m_sFacility;
    private Locale m_locale = Locale.getDefault();
    private String m_sPackage = "oracle.security.resources";

    public AdminMessageUtil(String string) {
        this(string, Locale.getDefault());
    }

    public AdminMessageUtil(String string, Locale locale) {
        if (locale != null) {
            this.m_locale = locale;
        }
        this.m_sFacility = string;
    }

    public AdminMessageUtil(Locale locale, String string) {
        this(string, locale);
    }

    public String getMessage(String string, boolean bl) {
        String string2 = this.getMyBundle().getString(string);
        if (!bl) {
            return string2;
        }
        return new String(String.valueOf(this.m_sFacility.toUpperCase()) + "-" + string + " : " + string2);
    }

    public String getMessage(String string, boolean bl, Object[] objectArray) {
        return MessageFormat.format(this.getMessage(string, bl), objectArray);
    }

    public synchronized String getPackage() {
        return this.m_sPackage;
    }

    public synchronized void setPackage(String string) throws MissingResourceException {
        this.m_sPackage = string;
        this.loadBundle(true);
    }

    private void loadBundle(boolean bl) {
        if (this.m_resBundle == null || bl) {
            String string = String.valueOf(this.m_sPackage) + "." + this.m_sFacility + "Msg";
            this.m_resBundle = ResourceBundle.getBundle(string, this.m_locale);
        }
    }

    private String getFacility() {
        return this.m_sFacility;
    }

    private Locale getLocale() {
        return this.m_locale;
    }

    private synchronized ResourceBundle getMyBundle() {
        this.loadBundle(false);
        return this.m_resBundle;
    }
}

